package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-28
 */
public enum InvoiceType {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    SE("se", "增值税电子专用发票"),
    CE("ce", "增值税电子普通发票"),
    CJ("cj", "增值税普通发票（卷票)"),
    CT("ct", "增值税电子普通发票（通行费)"),
    CB("cb", "增值税电子普通发票（区块链）"),
    CD("cd", "通用电子发票"),
    J("j", "机动车销售统一发票"),
    VS("vs", "二手车销售统一发票"),
    IM("im", "通用机打发票"),
    P("p", "飞机票行程单"),
    T("t", "火车票"),
    TAXI("taxi", "出租车"),
    QUOTA("quota", "定额发票"),
    TOLL("toll", "过路费"),
    BUS("bus", "客运票"),
    FJ("fj", "附件"),
    MULTI("multi", "多票"),
    OTHER("other", "其他发票"),
    VIRTUAL("virtual", "影像文档"),
    QC("qc", "电子发票（普通发票）"),
    QS("qs", "电子发票（增值税专用发票）"),
    PAYMENT("payment", "海关缴款书"),
    CDF("cdf", "海关货物报关单"),
    SALE("sale", "销货清单"),
    FCE("fce", "通用财政票据（电子）"),
    FC("fc", "财政票据"),
    MOE("moe", "医疗门诊收费票据（电子）"),
    MHE("mhe", "医疗住院收费票据（电子）"),
    CZ("cz", "纸质发票（普通发票）"),
    SZ("sz", "纸质发票（增值税专用发票）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "se":
                return SE;
            case "ce":
                return CE;
            case "cj":
                return CJ;
            case "ct":
                return CT;
            case "cb":
                return CB;
            case "cd":
                return CD;
            case "j":
                return J;
            case "vs":
                return VS;
            case "im":
                return IM;
            case "p":
                return P;
            case "t":
                return T;
            case "taxi":
                return TAXI;
            case "quota":
                return QUOTA;
            case "toll":
                return TOLL;
            case "bus":
                return BUS;
            case "fj":
                return FJ;
            case "multi":
                return MULTI;
            case "other":
                return OTHER;
            case "virtual":
                return VIRTUAL;
            case "qc":
                return QC;
            case "qs":
                return QS;
            case "payment":
                return PAYMENT;
            case "cdf":
                return CDF;
            case "sale":
                return SALE;
            case "fce":
                return FCE;
            case "fc":
                return FC;
            case "moe":
                return MOE;
            case "mhe":
                return MHE;
            case "cz":
                return CZ;
            case "sz":
                return SZ;
            default:
                return null;
        }
    }
}
