package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_type_code
 * </p>
 *
 * @author ultraman
 * @since 2024-01-08
 */
public enum BillTypeCode {

    A("A", "扫描发票"),
    B("B", "扫描无订单发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillTypeCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillTypeCode fromCode(String code){
        switch(code) {
            case "A":
                return A;
            case "B":
                return B;
            default:
                return null;
        }
    }
}
