package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * check_category
 * </p>
 *
 * @author ultraman
 * @since 2024-01-08
 */
public enum CheckCategory {

    BILL("BILL", "单据"),
    TICKET("TICKET", "单证"),
    COOP("COOP", "协同"),
    COMPARE_BILL("COMPARE_BILL", "收单单据"),
    COMPARE_TICKET("COMPARE_TICKET", "收单单证");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CheckCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckCategory fromCode(String code){
        switch(code) {
            case "BILL":
                return BILL;
            case "TICKET":
                return TICKET;
            case "COOP":
                return COOP;
            case "COMPARE_BILL":
                return COMPARE_BILL;
            case "COMPARE_TICKET":
                return COMPARE_TICKET;
            default:
                return null;
        }
    }
}
