package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * payee_subject
 * </p>
 *
 * @author ultraman
 * @since 2024-01-08
 */
public enum PayeeSubject {

    _1("1", "进口增值税"),
    _2("2", "进口关税"),
    _3("3", "进口消费税"),
    _4("4", "特别关税"),
    _5("5", "进口废弃电子电器产品处理基金");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PayeeSubject(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PayeeSubject fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
