package com.xforceplus.ultraman.app.imagesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 影像文件
 * </p>
 *
 * @author ultraman
 * @since 2024-01-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ImageFile implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 文件url
   */
  private String fileUrl;

  /**
   * 文件后缀
   */
  private String fileSuffix;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 任务编号
   */
  private String taskId;

  /**
   * 文件名称
   */
  private String fileName;

  /**
   * 业务单号
   */
  private String billCode;

  /**
   * 业务文件类型
   */
  private String businessFileType;

  /**
   * 单据类型
   */
  private String billEntityCode;

  /**
   * 所属租户
   */
  private String tenant;

  /**
   * 系统来源
   */
  private String systemOrig;

  /**
   * 是否公共
   */
  private String isPublic;

  /**
   * 是否需要识别
   */
  private String requireOcrFlag;

  /**
   * 是否转换图片
   */
  private String isTransform;

  /**
   * 附件名称
   */
  private String attachmentName;

  /**
   * 文件操作类型
   */
  private String fileOperationType;

  /**
   * 转换状态
   */
  private String transformStatus;

  /**
   * 用户代码
   */
  private String createUserCode;

  /**
   * 批次号
   */
  private String batchNo;

  /**
   * 文件key
   */
  private String fileKey;

  /**
   * 文件顺序
   */
  private String fileOrder;

  /**
   * 流水号
   */
  private String serialNumber;

  /**
   * 转换类型
   */
  private String transformType;

  /**
   * 任务类型
   */
  private String taskType;

  /**
   * 扩展字段
   */
  private String ext;

  /**
   * 文件MD5值
   */
  private String fileMd5;

  /**
   * 转换场景
   */
  private String transformScene;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("file_url", fileUrl);
      map.put("file_suffix", fileSuffix);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("task_id", taskId);
      map.put("file_name", fileName);
      map.put("bill_code", billCode);
      map.put("business_file_type", businessFileType);
      map.put("bill_entity_code", billEntityCode);
      map.put("tenant", tenant);
      map.put("system_orig", systemOrig);
      map.put("is_public", isPublic);
      map.put("require_ocr_flag", requireOcrFlag);
      map.put("is_transform", isTransform);
      map.put("attachment_name", attachmentName);
      map.put("file_operation_type", fileOperationType);
      map.put("transform_status", transformStatus);
      map.put("create_user_code", createUserCode);
      map.put("batch_no", batchNo);
      map.put("file_key", fileKey);
      map.put("file_order", fileOrder);
      map.put("serial_number", serialNumber);
      map.put("transform_type", transformType);
      map.put("task_type", taskType);
      map.put("ext", ext);
      map.put("file_md5", fileMd5);
      map.put("transform_scene", transformScene);

      return map;
  }

  public static ImageFile fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ImageFile entity = new ImageFile();
    if(map.containsKey("file_url")) {
      Object obj = map.get("file_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_suffix")) {
      Object obj = map.get("file_suffix");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFileSuffix((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("task_id")) {
      Object obj = map.get("task_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_name")) {
      Object obj = map.get("file_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_file_type")) {
      Object obj = map.get("business_file_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_entity_code")) {
      Object obj = map.get("bill_entity_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillEntityCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant")) {
      Object obj = map.get("tenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_public")) {
      Object obj = map.get("is_public");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsPublic((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("require_ocr_flag")) {
      Object obj = map.get("require_ocr_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRequireOcrFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_transform")) {
      Object obj = map.get("is_transform");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsTransform((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attachment_name")) {
      Object obj = map.get("attachment_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttachmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_operation_type")) {
      Object obj = map.get("file_operation_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFileOperationType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transform_status")) {
      Object obj = map.get("transform_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransformStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_user_code")) {
      Object obj = map.get("create_user_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_key")) {
      Object obj = map.get("file_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFileKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_order")) {
      Object obj = map.get("file_order");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFileOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serial_number")) {
      Object obj = map.get("serial_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSerialNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transform_type")) {
      Object obj = map.get("transform_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransformType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("task_type")) {
      Object obj = map.get("task_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaskType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext")) {
      Object obj = map.get("ext");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_md5")) {
      Object obj = map.get("file_md5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFileMd5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transform_scene")) {
      Object obj = map.get("transform_scene");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransformScene((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("file_url")) {
      Object obj = map.get("file_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFileUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("file_suffix")) {
      Object obj = map.get("file_suffix");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFileSuffix((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("task_id")) {
      Object obj = map.get("task_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaskId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("file_name")) {
      Object obj = map.get("file_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFileName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_file_type")) {
      Object obj = map.get("business_file_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessFileType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_entity_code")) {
      Object obj = map.get("bill_entity_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillEntityCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tenant")) {
      Object obj = map.get("tenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSystemOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_public")) {
      Object obj = map.get("is_public");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsPublic((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("require_ocr_flag")) {
      Object obj = map.get("require_ocr_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRequireOcrFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_transform")) {
      Object obj = map.get("is_transform");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsTransform((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attachment_name")) {
      Object obj = map.get("attachment_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttachmentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("file_operation_type")) {
      Object obj = map.get("file_operation_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFileOperationType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transform_status")) {
      Object obj = map.get("transform_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransformStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_user_code")) {
      Object obj = map.get("create_user_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("file_key")) {
      Object obj = map.get("file_key");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFileKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("file_order")) {
      Object obj = map.get("file_order");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFileOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("serial_number")) {
      Object obj = map.get("serial_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSerialNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transform_type")) {
      Object obj = map.get("transform_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransformType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("task_type")) {
      Object obj = map.get("task_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaskType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext")) {
      Object obj = map.get("ext");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("file_md5")) {
      Object obj = map.get("file_md5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFileMd5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transform_scene")) {
      Object obj = map.get("transform_scene");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransformScene((String)obj);
        }
      } else {
      }
    }
  }
}
