package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_check_options
 * </p>
 *
 * @author ultraman
 * @since 2024-04-09
 */
public enum BillCheckOptions {

    COMPARE_COUNT_CHECK("compare_count_check", "张数不一致异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillCheckOptions(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillCheckOptions fromCode(String code){
        switch(code) {
            case "compare_count_check":
                return COMPARE_COUNT_CHECK;
            default:
                return null;
        }
    }
}
