package com.xforceplus.ultraman.app.imagesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * task_history_type
 * </p>
 *
 * @author ultraman
 * @since 2024-04-09
 */
public enum TaskHistoryType {

    _1("1", "异常"),
    _2("2", "补偿失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaskHistoryType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskHistoryType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
