package com.xforceplus.ultraman.app.imagesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 文件类型
 * </p>
 *
 * @author ultraman
 * @since 2021-11-04
 */
public enum FileType {

    PNG("PNG", "PNG"),
    JPG("JPG", "JPG"),
    JPEG("JPEG", "JPEG"),
    PDF("PDF", "PDF"),
    OFD("OFD", "OFD");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FileType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileType fromCode(String code){
        switch(code) {
            case "PNG":
                return PNG;
            case "JPG":
                return JPG;
            case "JPEG":
                return JPEG;
            case "PDF":
                return PDF;
            case "OFD":
                return OFD;
            default:
                return null;
        }
    }
}
