package com.xforceplus.ultraman.app.imagesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 影像大类别
 * </p>
 *
 * @author ultraman
 * @since 2021-11-04
 */
public enum ImageCategory {

    _0("0", "未识别类型"),
    _1("1", "封面（结算单）"),
    _2("2", "大发票（单张）"),
    _3("3", "小发票（多张）"),
    _4("4", "裸扫大发票（单张）"),
    _5("5", "附件");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ImageCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImageCategory fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
