package com.xforceplus.ultraman.app.imagesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 操作对象
 * </p>
 *
 * @author ultraman
 * @since 2021-11-04
 */
public enum OperationEntity {

    BILL("bill", "单据"),
    TICKET("ticket", "单证"),
    IMAGE("image", "影像");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OperationEntity(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperationEntity fromCode(String code){
        switch(code) {
            case "bill":
                return BILL;
            case "ticket":
                return TICKET;
            case "image":
                return IMAGE;
            default:
                return null;
        }
    }
}
