package com.xforceplus.ultraman.app.imagesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据购销类型
 * </p>
 *
 * @author ultraman
 * @since 2021-11-04
 */
public enum SettlementType {

    AP("AP", "进项单据"),
    AR("AR", "销项单据");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SettlementType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SettlementType fromCode(String code){
        switch(code) {
            case "AP":
                return AP;
            case "AR":
                return AR;
            default:
                return null;
        }
    }
}
