package com.xforceplus.ultraman.app.imagesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据签收状态
 * </p>
 *
 * @author ultraman
 * @since 2021-11-04
 */
public enum SignStatus {

    _0("0", "未签收"),
    _1("1", "签收成功"),
    _99("99", "签收失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SignStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SignStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "99":
                return _99;
            default:
                return null;
        }
    }
}
