package com.xforceplus.ultraman.app.imagesaas.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * base_bill
 * </p>
 *
 * @author ultraman
 * @since 2021-11-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BaseBill implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 影像ID
   */
  private Long imageId;
  /**
   * 批次号
   */
  private String batchNo;
  /**
   * 单据对象code
   */
  private String billTypeCode;
  /**
   * 单据号
   */
  private String billCode;
  /**
   * 单据金额
   */
  private BigDecimal billAmountWithTax;
  /**
   * 单据含税金额
   */
  private BigDecimal billTaxAmount;
  /**
   * 单据不含税金额
   */
  private BigDecimal billAmountWithoutTax;
  /**
   * 提单人
   */
  private String billCreateUser;
  /**
   * 提单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billCreateTime;
  /**
   * 扫描人ID
   */
  private Long scanUserId;
  /**
   * 扫描人姓名
   */
  private String scanUserName;
  /**
   * 扫描时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime scanCreateTime;
  /**
   * 运单号
   */
  private String packageCode;
  /**
   * 物流状态
   */
  private String logisticsStatus;
  /**
   * 寄送时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime logisticsTime;
  /**
   * 签收状态
   */
  private String signStatus;
  /**
   * 签收时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signTime;
  /**
   * 是否公共
   */
  private String isPublic;
  /**
   * 物流备注
   */
  private String logisticRemark;
  /**
   * 挂起原因类型
   */
  private String hangType;
  /**
   * 挂起原因
   */
  private String hangReason;
  /**
   * 退回类型
   */
  private String backType;
  /**
   * 退回原因
   */
  private String backReason;
  /**
   * 单据状态
   */
  private String billDataStatus;
  /**
   * 状态变更时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billDataTime;
  /**
   * 核验签收状态
   */
  private String verifyStatus;
  /**
   * 核验签收时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime verifyTime;
  /**
   * 单据下的单证影像数量
   */
  private Long ticketCount;
  /**
   * 已有影像张数
   */
  private Long imageCount;
  /**
   * 异常数
   */
  private Long exceptionCount;
  /**
   * 预警数
   */
  private Long warningCount;
  /**
   * 单据是否异常
   */
  private String isException;
  /**
   * 单据异常信息
   */
  private String exceptionInfo;
  /**
   * 系统来源
   */
  private String systemOrig;
  /**
   * 是否敏感
   */
  private String isSecret;
  /**
   * 退回备注
   */
  private String backRemark;
  /**
   * 核验不合格类型
   */
  private String unqualityType;
  /**
   * 核验不合格原因
   */
  private String unqualityReason;
  /**
   * 核验挂起原因
   */
  private String verifyHangType;
  /**
   * 核验挂起备注
   */
  private String verifyHangReason;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 是否预付款
   */
  private String isPrepayment;
  /**
   * 扩展字段
   */
  private String extFields;
  /**
   * 外部状态
   */
  private String extStatus;
  /**
   * 预付款状态
   */
  private String prepaymentStatus;
  /**
   * 预付款变更时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime prepaymentTime;
  /**
   * 创建用户代码
   */
  private String createUserCode;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 购方税号
   */
  private String purchaserTaxNo;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 流水号
   */
  private String serialNumber;
  /**
   * 单据校验状态
   */
  private String billCheckStatus;
  /**
   * 购方代码
   */
  private String purchaserCode;
  /**
   * 单据校验状态变更时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billCheckTime;
  /**
   * 备注
   */
  private String remark;
  /**
   * 销方代码
   */
  private String sellerCode;
  /**
   * 租户名称
   */
  private String tenantCode;
  /**
   * 退回来源
   */
  private String backOrig;
  /**
   * 计算状态
   */
  private String calculateStatus;
  /**
   * 是否预警
   */
  private String isWarning;
  /**
   * 单据预警信息
   */
  private String warningInfo;
  /**
   * 购方编号
   */
  private String purchaserNo;
  /**
   * 退回人
   */
  private String backUser;
  /**
   * 保留字段1
   */
  private String reserved1;
  /**
   * 保留字段2
   */
  private String reserved2;
  /**
   * 保留字段3
   */
  private String reserved3;
  /**
   * 是否提交
   */
  private String isCommit;
  /**
   * 提交人ID
   */
  private Long commitUserId;
  /**
   * 提交人姓名
   */
  private String commitUserName;
  /**
   * 提交时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime commitTime;
  /**
   * 上传状态
   */
  private String uploadStatus;
  /**
   * 所属组织ID
   */
  private Long orgId;
  /**
   * 所属组织
   */
  private String orgName;
  /**
   * 所属组织代码
   */
  private String orgCode;
  /**
   * 是否推送单据
   */
  private String isPushBill;
  /**
   * 是否替换封面
   */
  private String isCover;
  /**
   * 系统来源
   */
  private String systemSource;
  /**
   * 是否新增
   */
  private String isAdd;
  /**
   * 是否变更
   */
  private String isChange;
  /**
   * 业务子类型
   */
  private String businessType;
  /**
   * 外部业务单号
   */
  private String settlementNo;
  /**
   * 单据用途
   */
  private String billUse;
  /**
   * 外部系统来源
   */
  private String systemOrigExternal;
  /**
   * 比对结果
   */
  private String compareStatus;
  /**
   * 稽核状态
   */
  private String auditStatus;
  /**
   * 稽核备注
   */
  private String auditRemark;
  /**
   * 付款状态
   */
  private String payStatus;
  /**
   * 单据完成时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime completeTime;
  /**
   * 单据购销类型
   */
  private String settlementType;
  /**
   * 单证异常
   */
  private String ticketException;
  /**
   * 单证预警
   */
  private String ticketWarning;

  /**
   * 对多关联关系 关联对象 image
   */
  private Long billOTOImageId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("image_id", imageId);
      map.put("batch_no", batchNo);
      map.put("bill_type_code", billTypeCode);
      map.put("bill_code", billCode);
      map.put("bill_amount_with_tax", billAmountWithTax);
      map.put("bill_tax_amount", billTaxAmount);
      map.put("bill_amount_without_tax", billAmountWithoutTax);
      map.put("bill_create_user", billCreateUser);
      map.put("bill_create_time", BocpGenUtils.toTimestamp(billCreateTime));
      map.put("scan_user_id", scanUserId);
      map.put("scan_user_name", scanUserName);
      map.put("scan_create_time", BocpGenUtils.toTimestamp(scanCreateTime));
      map.put("package_code", packageCode);
      map.put("logistics_status", logisticsStatus);
      map.put("logistics_time", BocpGenUtils.toTimestamp(logisticsTime));
      map.put("sign_status", signStatus);
      map.put("sign_time", BocpGenUtils.toTimestamp(signTime));
      map.put("is_public", isPublic);
      map.put("logistic_remark", logisticRemark);
      map.put("hang_type", hangType);
      map.put("hang_reason", hangReason);
      map.put("back_type", backType);
      map.put("back_reason", backReason);
      map.put("bill_data_status", billDataStatus);
      map.put("bill_data_time", BocpGenUtils.toTimestamp(billDataTime));
      map.put("verify_status", verifyStatus);
      map.put("verify_time", BocpGenUtils.toTimestamp(verifyTime));
      map.put("ticket_count", ticketCount);
      map.put("image_count", imageCount);
      map.put("exception_count", exceptionCount);
      map.put("warning_count", warningCount);
      map.put("is_exception", isException);
      map.put("exception_info", exceptionInfo);
      map.put("system_orig", systemOrig);
      map.put("is_secret", isSecret);
      map.put("back_remark", backRemark);
      map.put("unquality_type", unqualityType);
      map.put("unquality_reason", unqualityReason);
      map.put("verify_hang_type", verifyHangType);
      map.put("verify_hang_reason", verifyHangReason);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("is_prepayment", isPrepayment);
      map.put("ext_fields", extFields);
      map.put("ext_status", extStatus);
      map.put("prepayment_status", prepaymentStatus);
      map.put("prepayment_time", BocpGenUtils.toTimestamp(prepaymentTime));
      map.put("create_user_code", createUserCode);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("seller_name", sellerName);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("purchaser_name", purchaserName);
      map.put("serial_number", serialNumber);
      map.put("bill_check_status", billCheckStatus);
      map.put("purchaser_code", purchaserCode);
      map.put("bill_check_time", BocpGenUtils.toTimestamp(billCheckTime));
      map.put("remark", remark);
      map.put("seller_code", sellerCode);
      map.put("tenant_code", tenantCode);
      map.put("back_orig", backOrig);
      map.put("calculate_status", calculateStatus);
      map.put("is_warning", isWarning);
      map.put("warning_info", warningInfo);
      map.put("purchaser_no", purchaserNo);
      map.put("back_user", backUser);
      map.put("reserved1", reserved1);
      map.put("reserved2", reserved2);
      map.put("reserved3", reserved3);
      map.put("is_commit", isCommit);
      map.put("commit_user_id", commitUserId);
      map.put("commit_user_name", commitUserName);
      map.put("commit_time", BocpGenUtils.toTimestamp(commitTime));
      map.put("upload_status", uploadStatus);
      map.put("org_id", orgId);
      map.put("org_name", orgName);
      map.put("org_code", orgCode);
      map.put("is_push_bill", isPushBill);
      map.put("is_cover", isCover);
      map.put("system_source", systemSource);
      map.put("is_add", isAdd);
      map.put("is_change", isChange);
      map.put("business_type", businessType);
      map.put("settlement_no", settlementNo);
      map.put("bill_use", billUse);
      map.put("system_orig_external", systemOrigExternal);
      map.put("compare_status", compareStatus);
      map.put("audit_status", auditStatus);
      map.put("audit_remark", auditRemark);
      map.put("pay_status", payStatus);
      map.put("complete_time", BocpGenUtils.toTimestamp(completeTime));
      map.put("settlement_type", settlementType);
      map.put("ticket_exception", ticketException);
      map.put("ticket_warning", ticketWarning);

      map.put("billOTOImage.id", billOTOImageId);
      return map;
  }

  public static BaseBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BaseBill entity = new BaseBill();

    if(map.containsKey("image_id")) {
      Object obj = map.get("image_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageId((Long)obj);
        } else if(obj instanceof String) {
          entity.setImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setImageId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_type_code")) {
      Object obj = map.get("bill_type_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_amount_with_tax")) {
      Object obj = map.get("bill_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBillAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_tax_amount")) {
      Object obj = map.get("bill_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBillTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_amount_without_tax")) {
      Object obj = map.get("bill_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBillAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_create_user")) {
      Object obj = map.get("bill_create_user");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_create_time")) {
      Object obj = map.get("bill_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBillCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBillCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillCreateTime(null);
      }
    }
    if(map.containsKey("scan_user_id")) {
      Object obj = map.get("scan_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setScanUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setScanUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("scan_user_name")) {
      Object obj = map.get("scan_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scan_create_time")) {
      Object obj = map.get("scan_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setScanCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setScanCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setScanCreateTime(null);
      }
    }
    if(map.containsKey("package_code")) {
      Object obj = map.get("package_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPackageCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_status")) {
      Object obj = map.get("logistics_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLogisticsStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_time")) {
      Object obj = map.get("logistics_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLogisticsTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setLogisticsTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setLogisticsTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLogisticsTime(null);
      }
    }
    if(map.containsKey("sign_status")) {
      Object obj = map.get("sign_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_time")) {
      Object obj = map.get("sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSignTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignTime(null);
      }
    }
    if(map.containsKey("is_public")) {
      Object obj = map.get("is_public");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsPublic((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistic_remark")) {
      Object obj = map.get("logistic_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLogisticRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_type")) {
      Object obj = map.get("hang_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHangType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_reason")) {
      Object obj = map.get("hang_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHangReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_type")) {
      Object obj = map.get("back_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_reason")) {
      Object obj = map.get("back_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_data_status")) {
      Object obj = map.get("bill_data_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_data_time")) {
      Object obj = map.get("bill_data_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillDataTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBillDataTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBillDataTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillDataTime(null);
      }
    }
    if(map.containsKey("verify_status")) {
      Object obj = map.get("verify_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_time")) {
      Object obj = map.get("verify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVerifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setVerifyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVerifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVerifyTime(null);
      }
    }
    if(map.containsKey("ticket_count")) {
      Object obj = map.get("ticket_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTicketCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setTicketCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTicketCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("image_count")) {
      Object obj = map.get("image_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setImageCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setImageCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("exception_count")) {
      Object obj = map.get("exception_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExceptionCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setExceptionCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setExceptionCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("warning_count")) {
      Object obj = map.get("warning_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWarningCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setWarningCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setWarningCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_exception")) {
      Object obj = map.get("is_exception");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsException((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_secret")) {
      Object obj = map.get("is_secret");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsSecret((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_remark")) {
      Object obj = map.get("back_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unquality_type")) {
      Object obj = map.get("unquality_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnqualityType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unquality_reason")) {
      Object obj = map.get("unquality_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnqualityReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_hang_type")) {
      Object obj = map.get("verify_hang_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyHangType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_hang_reason")) {
      Object obj = map.get("verify_hang_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyHangReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_prepayment")) {
      Object obj = map.get("is_prepayment");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsPrepayment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext_fields")) {
      Object obj = map.get("ext_fields");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtFields((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext_status")) {
      Object obj = map.get("ext_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepayment_status")) {
      Object obj = map.get("prepayment_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrepaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepayment_time")) {
      Object obj = map.get("prepayment_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPrepaymentTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPrepaymentTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPrepaymentTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPrepaymentTime(null);
      }
    }
    if(map.containsKey("create_user_code")) {
      Object obj = map.get("create_user_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serial_number")) {
      Object obj = map.get("serial_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSerialNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_check_status")) {
      Object obj = map.get("bill_check_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_code")) {
      Object obj = map.get("purchaser_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_check_time")) {
      Object obj = map.get("bill_check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBillCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBillCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillCheckTime(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_code")) {
      Object obj = map.get("seller_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_orig")) {
      Object obj = map.get("back_orig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("calculate_status")) {
      Object obj = map.get("calculate_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCalculateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_warning")) {
      Object obj = map.get("is_warning");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsWarning((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_info")) {
      Object obj = map.get("warning_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_user")) {
      Object obj = map.get("back_user");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBackUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved1")) {
      Object obj = map.get("reserved1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved2")) {
      Object obj = map.get("reserved2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved3")) {
      Object obj = map.get("reserved3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserved3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_commit")) {
      Object obj = map.get("is_commit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsCommit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_user_id")) {
      Object obj = map.get("commit_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCommitUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCommitUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("commit_user_name")) {
      Object obj = map.get("commit_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCommitUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_time")) {
      Object obj = map.get("commit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCommitTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCommitTime(null);
      }
    }
    if(map.containsKey("upload_status")) {
      Object obj = map.get("upload_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUploadStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_push_bill")) {
      Object obj = map.get("is_push_bill");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsPushBill((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_cover")) {
      Object obj = map.get("is_cover");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsCover((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_source")) {
      Object obj = map.get("system_source");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_add")) {
      Object obj = map.get("is_add");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsAdd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_change")) {
      Object obj = map.get("is_change");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsChange((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_use")) {
      Object obj = map.get("bill_use");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_orig_external")) {
      Object obj = map.get("system_orig_external");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemOrigExternal((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compare_status")) {
      Object obj = map.get("compare_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompareStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_remark")) {
      Object obj = map.get("audit_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_status")) {
      Object obj = map.get("pay_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("complete_time")) {
      Object obj = map.get("complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCompleteTime(null);
      }
    }
    if(map.containsKey("settlement_type")) {
      Object obj = map.get("settlement_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_exception")) {
      Object obj = map.get("ticket_exception");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketException((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_warning")) {
      Object obj = map.get("ticket_warning");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketWarning((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("billOTOImage.id")) {
       entity.setBillOTOImageId((Long)map.get("billOTOImage.id" ));
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("image_id")) {
      Object obj = map.get("image_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setImageId((Long)obj);
        } else if(obj instanceof String) {
            this.setImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setImageId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setBatchNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bill_type_code")) {
      Object obj = map.get("bill_type_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillTypeCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bill_amount_with_tax")) {
      Object obj = map.get("bill_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBillAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBillAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBillAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setBillAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBillAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("bill_tax_amount")) {
      Object obj = map.get("bill_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBillTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBillTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBillTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setBillTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBillTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("bill_amount_without_tax")) {
      Object obj = map.get("bill_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setBillAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setBillAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setBillAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setBillAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setBillAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("bill_create_user")) {
      Object obj = map.get("bill_create_user");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillCreateUser((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bill_create_time")) {
      Object obj = map.get("bill_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBillCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setBillCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setBillCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setBillCreateTime(null);
      }
   }
    if(map.containsKey("scan_user_id")) {
      Object obj = map.get("scan_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setScanUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setScanUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setScanUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("scan_user_name")) {
      Object obj = map.get("scan_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setScanUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("scan_create_time")) {
      Object obj = map.get("scan_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setScanCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setScanCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setScanCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setScanCreateTime(null);
      }
   }
    if(map.containsKey("package_code")) {
      Object obj = map.get("package_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setPackageCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("logistics_status")) {
      Object obj = map.get("logistics_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setLogisticsStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("logistics_time")) {
      Object obj = map.get("logistics_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLogisticsTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setLogisticsTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setLogisticsTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setLogisticsTime(null);
      }
   }
    if(map.containsKey("sign_status")) {
      Object obj = map.get("sign_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setSignStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sign_time")) {
      Object obj = map.get("sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSignTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSignTime(null);
      }
   }
    if(map.containsKey("is_public")) {
      Object obj = map.get("is_public");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsPublic((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("logistic_remark")) {
      Object obj = map.get("logistic_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setLogisticRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("hang_type")) {
      Object obj = map.get("hang_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setHangType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("hang_reason")) {
      Object obj = map.get("hang_reason");
      if(obj != null) {
        if(obj instanceof String){
            this.setHangReason((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("back_type")) {
      Object obj = map.get("back_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setBackType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("back_reason")) {
      Object obj = map.get("back_reason");
      if(obj != null) {
        if(obj instanceof String){
            this.setBackReason((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bill_data_status")) {
      Object obj = map.get("bill_data_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillDataStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bill_data_time")) {
      Object obj = map.get("bill_data_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBillDataTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setBillDataTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setBillDataTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setBillDataTime(null);
      }
   }
    if(map.containsKey("verify_status")) {
      Object obj = map.get("verify_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setVerifyStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("verify_time")) {
      Object obj = map.get("verify_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setVerifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setVerifyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setVerifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setVerifyTime(null);
      }
   }
    if(map.containsKey("ticket_count")) {
      Object obj = map.get("ticket_count");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTicketCount((Long)obj);
        } else if(obj instanceof String) {
            this.setTicketCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTicketCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("image_count")) {
      Object obj = map.get("image_count");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setImageCount((Long)obj);
        } else if(obj instanceof String) {
            this.setImageCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setImageCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("exception_count")) {
      Object obj = map.get("exception_count");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setExceptionCount((Long)obj);
        } else if(obj instanceof String) {
            this.setExceptionCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setExceptionCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("warning_count")) {
      Object obj = map.get("warning_count");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setWarningCount((Long)obj);
        } else if(obj instanceof String) {
            this.setWarningCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setWarningCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("is_exception")) {
      Object obj = map.get("is_exception");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsException((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String){
            this.setExceptionInfo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String){
            this.setSystemOrig((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("is_secret")) {
      Object obj = map.get("is_secret");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsSecret((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("back_remark")) {
      Object obj = map.get("back_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setBackRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("unquality_type")) {
      Object obj = map.get("unquality_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setUnqualityType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("unquality_reason")) {
      Object obj = map.get("unquality_reason");
      if(obj != null) {
        if(obj instanceof String){
            this.setUnqualityReason((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("verify_hang_type")) {
      Object obj = map.get("verify_hang_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setVerifyHangType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("verify_hang_reason")) {
      Object obj = map.get("verify_hang_reason");
      if(obj != null) {
        if(obj instanceof String){
            this.setVerifyHangReason((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("is_prepayment")) {
      Object obj = map.get("is_prepayment");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsPrepayment((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext_fields")) {
      Object obj = map.get("ext_fields");
      if(obj != null) {
        if(obj instanceof String){
            this.setExtFields((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext_status")) {
      Object obj = map.get("ext_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setExtStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("prepayment_status")) {
      Object obj = map.get("prepayment_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setPrepaymentStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("prepayment_time")) {
      Object obj = map.get("prepayment_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPrepaymentTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPrepaymentTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setPrepaymentTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPrepaymentTime(null);
      }
   }
    if(map.containsKey("create_user_code")) {
      Object obj = map.get("create_user_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("serial_number")) {
      Object obj = map.get("serial_number");
      if(obj != null) {
        if(obj instanceof String){
            this.setSerialNumber((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bill_check_status")) {
      Object obj = map.get("bill_check_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillCheckStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_code")) {
      Object obj = map.get("purchaser_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bill_check_time")) {
      Object obj = map.get("bill_check_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBillCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setBillCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setBillCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setBillCheckTime(null);
      }
   }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_code")) {
      Object obj = map.get("seller_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("back_orig")) {
      Object obj = map.get("back_orig");
      if(obj != null) {
        if(obj instanceof String){
            this.setBackOrig((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("calculate_status")) {
      Object obj = map.get("calculate_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setCalculateStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("is_warning")) {
      Object obj = map.get("is_warning");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsWarning((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("warning_info")) {
      Object obj = map.get("warning_info");
      if(obj != null) {
        if(obj instanceof String){
            this.setWarningInfo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("back_user")) {
      Object obj = map.get("back_user");
      if(obj != null) {
        if(obj instanceof String){
            this.setBackUser((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("reserved1")) {
      Object obj = map.get("reserved1");
      if(obj != null) {
        if(obj instanceof String){
            this.setReserved1((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("reserved2")) {
      Object obj = map.get("reserved2");
      if(obj != null) {
        if(obj instanceof String){
            this.setReserved2((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("reserved3")) {
      Object obj = map.get("reserved3");
      if(obj != null) {
        if(obj instanceof String){
            this.setReserved3((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("is_commit")) {
      Object obj = map.get("is_commit");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsCommit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("commit_user_id")) {
      Object obj = map.get("commit_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCommitUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCommitUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCommitUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("commit_user_name")) {
      Object obj = map.get("commit_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCommitUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("commit_time")) {
      Object obj = map.get("commit_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCommitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCommitTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCommitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCommitTime(null);
      }
   }
    if(map.containsKey("upload_status")) {
      Object obj = map.get("upload_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setUploadStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrgId((Long)obj);
        } else if(obj instanceof String) {
            this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrgName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrgCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("is_push_bill")) {
      Object obj = map.get("is_push_bill");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsPushBill((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("is_cover")) {
      Object obj = map.get("is_cover");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsCover((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("system_source")) {
      Object obj = map.get("system_source");
      if(obj != null) {
        if(obj instanceof String){
            this.setSystemSource((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("is_add")) {
      Object obj = map.get("is_add");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsAdd((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("is_change")) {
      Object obj = map.get("is_change");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsChange((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setSettlementNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bill_use")) {
      Object obj = map.get("bill_use");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillUse((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("system_orig_external")) {
      Object obj = map.get("system_orig_external");
      if(obj != null) {
        if(obj instanceof String){
            this.setSystemOrigExternal((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("compare_status")) {
      Object obj = map.get("compare_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setCompareStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuditStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("audit_remark")) {
      Object obj = map.get("audit_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuditRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("pay_status")) {
      Object obj = map.get("pay_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setPayStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("complete_time")) {
      Object obj = map.get("complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCompleteTime(null);
      }
   }
    if(map.containsKey("settlement_type")) {
      Object obj = map.get("settlement_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setSettlementType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ticket_exception")) {
      Object obj = map.get("ticket_exception");
      if(obj != null) {
        if(obj instanceof String){
            this.setTicketException((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ticket_warning")) {
      Object obj = map.get("ticket_warning");
      if(obj != null) {
        if(obj instanceof String){
            this.setTicketWarning((String)obj);
        }
      } else{
      }
   }

  if(map.containsKey("billOTOImage.id")) {
    this.setBillOTOImageId((Long)map.get("billOTOImage.id" ));
  }
  }

}
