package com.xforceplus.ultraman.app.imagesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 币种
 * </p>
 *
 * @author ultraman
 * @since 2022-03-03
 */
public enum CurrencyType {

    CNY("CNY", "人民币"),
    USD("USD", "美元"),
    EUR("EUR", "欧元"),
    JPY("JPY", "日元"),
    NZD("NZD", "新西兰元"),
    SGD("SGD", "新加坡元"),
    CHF("CHF", "瑞士法郎"),
    AUD("AUD", "澳大利亚元"),
    RUB("RUB", "卢布"),
    HKD("HKD", "港币"),
    GBP("GBP", "英镑");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CurrencyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CurrencyType fromCode(String code){
        switch(code) {
            case "CNY":
                return CNY;
            case "USD":
                return USD;
            case "EUR":
                return EUR;
            case "JPY":
                return JPY;
            case "NZD":
                return NZD;
            case "SGD":
                return SGD;
            case "CHF":
                return CHF;
            case "AUD":
                return AUD;
            case "RUB":
                return RUB;
            case "HKD":
                return HKD;
            case "GBP":
                return GBP;
            default:
                return null;
        }
    }
}
