package com.xforceplus.ultraman.app.imagesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 部署模式
 * </p>
 *
 * @author ultraman
 * @since 2022-03-03
 */
public enum DeployMode {

    SAAS("SAAS", "SAAS云服务"),
    LOCAL("LOCAL", "属地服务");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DeployMode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DeployMode fromCode(String code){
        switch(code) {
            case "SAAS":
                return SAAS;
            case "LOCAL":
                return LOCAL;
            default:
                return null;
        }
    }
}
