package com.xforceplus.ultraman.app.imagesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 文件操作类型
 * </p>
 *
 * @author ultraman
 * @since 2022-03-03
 */
public enum FileOperationType {

    COVER("cover", "覆盖"),
    HOOK("hook", "挂接");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FileOperationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileOperationType fromCode(String code){
        switch(code) {
            case "cover":
                return COVER;
            case "hook":
                return HOOK;
            default:
                return null;
        }
    }
}
