package com.xforceplus.ultraman.app.imagesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单证检测ICON
 * </p>
 *
 * @author ultraman
 * @since 2022-03-03
 */
public enum TicketCheckIcons {

    BASE_CHECK("base_check", "基"),
    TITLE_CHECK("title_check", "购"),
    BLACKLIST_CHECK("blacklist_check", "黑"),
    SENSITIVE_CHECK("sensitive_check", "敏"),
    COORDINATION_CHECK("coordination_check", "销"),
    ELECTRONIC_CHECK("electronic_check", "匹"),
    ERROR_CODE_NO_CHECK("error_code_no_check", "串"),
    INVOICE_STATUS_CHECK("invoice_status_check", "状"),
    IS_REPLACE_CHECK("is_replace_check", "代"),
    LEGAL_PERSON_CHECK("legal_person_check", "主"),
    PERSON_CHECK("person_check", "购"),
    REPEAT_CHECK("repeat_check", "重"),
    SALES_LIST_CHECK("sales_list_check", "货"),
    CONSECUTIVE_CHECK("consecutive_check", "连"),
    SHEET_CHECK("sheet_check", "缺"),
    STAMPER_CHECK("stamper_check", "缺"),
    USER_AUTH_CHECK("user_auth_check", "权"),
    VERIFY_RESULT_CHECK("verify_result_check", "验"),
    SIGN_RESULT_CHECK("sign_result_check", "签"),
    PURCHASE_REPEAT_CHECK("purchase_repeat_check", "重"),
    SHEET_DEDUCT_CHECK("sheet_deduct_check", "抵"),
    TICKET_REMARK_CHECK("ticket_remark_check", "备"),
    REC_FAILED_CHECK("rec_failed_check", "识"),
    USED_AMOUNT_CHECK("used_amount_check", "提");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TicketCheckIcons(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TicketCheckIcons fromCode(String code){
        switch(code) {
            case "base_check":
                return BASE_CHECK;
            case "title_check":
                return TITLE_CHECK;
            case "blacklist_check":
                return BLACKLIST_CHECK;
            case "sensitive_check":
                return SENSITIVE_CHECK;
            case "coordination_check":
                return COORDINATION_CHECK;
            case "electronic_check":
                return ELECTRONIC_CHECK;
            case "error_code_no_check":
                return ERROR_CODE_NO_CHECK;
            case "invoice_status_check":
                return INVOICE_STATUS_CHECK;
            case "is_replace_check":
                return IS_REPLACE_CHECK;
            case "legal_person_check":
                return LEGAL_PERSON_CHECK;
            case "person_check":
                return PERSON_CHECK;
            case "repeat_check":
                return REPEAT_CHECK;
            case "sales_list_check":
                return SALES_LIST_CHECK;
            case "consecutive_check":
                return CONSECUTIVE_CHECK;
            case "sheet_check":
                return SHEET_CHECK;
            case "stamper_check":
                return STAMPER_CHECK;
            case "user_auth_check":
                return USER_AUTH_CHECK;
            case "verify_result_check":
                return VERIFY_RESULT_CHECK;
            case "sign_result_check":
                return SIGN_RESULT_CHECK;
            case "purchase_repeat_check":
                return PURCHASE_REPEAT_CHECK;
            case "sheet_deduct_check":
                return SHEET_DEDUCT_CHECK;
            case "ticket_remark_check":
                return TICKET_REMARK_CHECK;
            case "rec_failed_check":
                return REC_FAILED_CHECK;
            case "used_amount_check":
                return USED_AMOUNT_CHECK;
            default:
                return null;
        }
    }
}
