package com.xforceplus.ultraman.app.imagesaas.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * config_settings
 * </p>
 *
 * @author ultraman
 * @since 2022-03-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ConfigSettings implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 是否默认
   */
  private String isDefault;
  /**
   * 是否启用
   */
  private String enable;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 所属租户
   */
  private Long tenant;
  /**
   * 识别超时改为附件秒数
   */
  private Long imageToAnnexSeconds;
  /**
   * 影像采集是否支持全租户查询
   */
  private String scanIsSupportAllTenant;
  /**
   * 查看未挂接影像天数
   */
  private Long searchNoRealDay;
  /**
   * 是否自动发送验真
   */
  private String ticketAutoSendVerify;
  /**
   * 是否全量推送数据
   */
  private String isAllPushData;
  /**
   * 是否支持复用
   */
  private String ticketIsSupportReuse;
  /**
   * 是否校验黑名单
   */
  private String ticketIsCheckBlack;
  /**
   * 是否校验敏感词
   */
  private String ticketIsCheckSensitive;
  /**
   * 是否校验法人主数据
   */
  private String ticketIsCheckLegalperson;
  /**
   * 单据号是否需要转换
   */
  private String billCodeIsNeedTrans;
  /**
   * 空图
   */
  private String emptyUrl;
  /**
   * 票税助手开关
   */
  private String isSupportPszs;
  /**
   * debug模式
   */
  private String debugModel;
  /**
   * 多票模式
   */
  private String splitMoreImage;
  /**
   * 需要清单的单据对象
   */
  private String billTypeCodeNeedList;
  /**
   * 单据号正则提取
   */
  private String billCodeRegexSplit;
  /**
   * 租户名称
   */
  private String tenantCode;
  /**
   * 扩展字段1
   */
  private String extension1;
  /**
   * 扩展字段2
   */
  private String extension2;
  /**
   * 扩展字段3
   */
  private String extension3;
  /**
   * 销货清单异常预警配置
   */
  private String salesListConfig;
  /**
   * 扫描助手扫描模式
   */
  private String scanClientScanModel;
  /**
   * sharepoint分批下发影像数
   */
  private Long sharepointSendImageNum;
  /**
   * websocket请求地址
   */
  private String websocketUrl;
  /**
   * 可识别的对象代码
   */
  private String discernEntityCodes;
  /**
   * 文件转换超时改为附件秒数
   */
  private Long fileToAnnexSeconds;
  /**
   * 验真结果超时改为失败秒数
   */
  private Long verifyToAnnexSeconds;
  /**
   * 是否一票多用
   */
  private String isMultipurposeTicket;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("is_default", isDefault);
      map.put("enable", enable);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("tenant", tenant);
      map.put("image_to_annex_seconds", imageToAnnexSeconds);
      map.put("scan_is_support_all_tenant", scanIsSupportAllTenant);
      map.put("search_no_real_day", searchNoRealDay);
      map.put("ticket_auto_send_verify", ticketAutoSendVerify);
      map.put("is_all_push_data", isAllPushData);
      map.put("ticket_is_support_reuse", ticketIsSupportReuse);
      map.put("ticket_is_check_black", ticketIsCheckBlack);
      map.put("ticket_is_check_sensitive", ticketIsCheckSensitive);
      map.put("ticket_is_check_legalperson", ticketIsCheckLegalperson);
      map.put("bill_code_is_need_trans", billCodeIsNeedTrans);
      map.put("empty_url", emptyUrl);
      map.put("is_support_pszs", isSupportPszs);
      map.put("debug_model", debugModel);
      map.put("split_more_image", splitMoreImage);
      map.put("bill_type_code_need_list", billTypeCodeNeedList);
      map.put("bill_code_regex_split", billCodeRegexSplit);
      map.put("tenant_code", tenantCode);
      map.put("extension1", extension1);
      map.put("extension2", extension2);
      map.put("extension3", extension3);
      map.put("sales_list_config", salesListConfig);
      map.put("scan_client_scan_model", scanClientScanModel);
      map.put("sharepoint_send_image_num", sharepointSendImageNum);
      map.put("websocket_url", websocketUrl);
      map.put("discern_entity_codes", discernEntityCodes);
      map.put("file_to_annex_seconds", fileToAnnexSeconds);
      map.put("verify_to_annex_seconds", verifyToAnnexSeconds);
      map.put("is_multipurpose_ticket", isMultipurposeTicket);

      return map;
  }

  public static ConfigSettings fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ConfigSettings entity = new ConfigSettings();

    if(map.containsKey("is_default")) {
      Object obj = map.get("is_default");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsDefault((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("enable")) {
      Object obj = map.get("enable");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant")) {
      Object obj = map.get("tenant");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenant((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenant(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenant(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("image_to_annex_seconds")) {
      Object obj = map.get("image_to_annex_seconds");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageToAnnexSeconds((Long)obj);
        } else if(obj instanceof String) {
          entity.setImageToAnnexSeconds(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setImageToAnnexSeconds(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("scan_is_support_all_tenant")) {
      Object obj = map.get("scan_is_support_all_tenant");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanIsSupportAllTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("search_no_real_day")) {
      Object obj = map.get("search_no_real_day");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSearchNoRealDay((Long)obj);
        } else if(obj instanceof String) {
          entity.setSearchNoRealDay(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSearchNoRealDay(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ticket_auto_send_verify")) {
      Object obj = map.get("ticket_auto_send_verify");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketAutoSendVerify((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_all_push_data")) {
      Object obj = map.get("is_all_push_data");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsAllPushData((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_is_support_reuse")) {
      Object obj = map.get("ticket_is_support_reuse");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketIsSupportReuse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_is_check_black")) {
      Object obj = map.get("ticket_is_check_black");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketIsCheckBlack((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_is_check_sensitive")) {
      Object obj = map.get("ticket_is_check_sensitive");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketIsCheckSensitive((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_is_check_legalperson")) {
      Object obj = map.get("ticket_is_check_legalperson");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTicketIsCheckLegalperson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_code_is_need_trans")) {
      Object obj = map.get("bill_code_is_need_trans");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCodeIsNeedTrans((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("empty_url")) {
      Object obj = map.get("empty_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEmptyUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_support_pszs")) {
      Object obj = map.get("is_support_pszs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsSupportPszs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("debug_model")) {
      Object obj = map.get("debug_model");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDebugModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("split_more_image")) {
      Object obj = map.get("split_more_image");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSplitMoreImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_type_code_need_list")) {
      Object obj = map.get("bill_type_code_need_list");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillTypeCodeNeedList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_code_regex_split")) {
      Object obj = map.get("bill_code_regex_split");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCodeRegexSplit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extension1")) {
      Object obj = map.get("extension1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtension1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extension2")) {
      Object obj = map.get("extension2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtension2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extension3")) {
      Object obj = map.get("extension3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtension3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sales_list_config")) {
      Object obj = map.get("sales_list_config");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesListConfig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scan_client_scan_model")) {
      Object obj = map.get("scan_client_scan_model");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanClientScanModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sharepoint_send_image_num")) {
      Object obj = map.get("sharepoint_send_image_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSharepointSendImageNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setSharepointSendImageNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSharepointSendImageNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("websocket_url")) {
      Object obj = map.get("websocket_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWebsocketUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discern_entity_codes")) {
      Object obj = map.get("discern_entity_codes");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscernEntityCodes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_to_annex_seconds")) {
      Object obj = map.get("file_to_annex_seconds");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFileToAnnexSeconds((Long)obj);
        } else if(obj instanceof String) {
          entity.setFileToAnnexSeconds(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFileToAnnexSeconds(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("verify_to_annex_seconds")) {
      Object obj = map.get("verify_to_annex_seconds");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVerifyToAnnexSeconds((Long)obj);
        } else if(obj instanceof String) {
          entity.setVerifyToAnnexSeconds(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVerifyToAnnexSeconds(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_multipurpose_ticket")) {
      Object obj = map.get("is_multipurpose_ticket");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsMultipurposeTicket((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("is_default")) {
      Object obj = map.get("is_default");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsDefault((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("enable")) {
      Object obj = map.get("enable");
      if(obj != null) {
        if(obj instanceof String){
            this.setEnable((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tenant")) {
      Object obj = map.get("tenant");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenant((Long)obj);
        } else if(obj instanceof String) {
            this.setTenant(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenant(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("image_to_annex_seconds")) {
      Object obj = map.get("image_to_annex_seconds");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setImageToAnnexSeconds((Long)obj);
        } else if(obj instanceof String) {
            this.setImageToAnnexSeconds(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setImageToAnnexSeconds(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("scan_is_support_all_tenant")) {
      Object obj = map.get("scan_is_support_all_tenant");
      if(obj != null) {
        if(obj instanceof String){
            this.setScanIsSupportAllTenant((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("search_no_real_day")) {
      Object obj = map.get("search_no_real_day");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSearchNoRealDay((Long)obj);
        } else if(obj instanceof String) {
            this.setSearchNoRealDay(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSearchNoRealDay(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("ticket_auto_send_verify")) {
      Object obj = map.get("ticket_auto_send_verify");
      if(obj != null) {
        if(obj instanceof String){
            this.setTicketAutoSendVerify((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("is_all_push_data")) {
      Object obj = map.get("is_all_push_data");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsAllPushData((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ticket_is_support_reuse")) {
      Object obj = map.get("ticket_is_support_reuse");
      if(obj != null) {
        if(obj instanceof String){
            this.setTicketIsSupportReuse((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ticket_is_check_black")) {
      Object obj = map.get("ticket_is_check_black");
      if(obj != null) {
        if(obj instanceof String){
            this.setTicketIsCheckBlack((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ticket_is_check_sensitive")) {
      Object obj = map.get("ticket_is_check_sensitive");
      if(obj != null) {
        if(obj instanceof String){
            this.setTicketIsCheckSensitive((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ticket_is_check_legalperson")) {
      Object obj = map.get("ticket_is_check_legalperson");
      if(obj != null) {
        if(obj instanceof String){
            this.setTicketIsCheckLegalperson((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bill_code_is_need_trans")) {
      Object obj = map.get("bill_code_is_need_trans");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillCodeIsNeedTrans((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("empty_url")) {
      Object obj = map.get("empty_url");
      if(obj != null) {
        if(obj instanceof String){
            this.setEmptyUrl((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("is_support_pszs")) {
      Object obj = map.get("is_support_pszs");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsSupportPszs((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("debug_model")) {
      Object obj = map.get("debug_model");
      if(obj != null) {
        if(obj instanceof String){
            this.setDebugModel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("split_more_image")) {
      Object obj = map.get("split_more_image");
      if(obj != null) {
        if(obj instanceof String){
            this.setSplitMoreImage((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bill_type_code_need_list")) {
      Object obj = map.get("bill_type_code_need_list");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillTypeCodeNeedList((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bill_code_regex_split")) {
      Object obj = map.get("bill_code_regex_split");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillCodeRegexSplit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("extension1")) {
      Object obj = map.get("extension1");
      if(obj != null) {
        if(obj instanceof String){
            this.setExtension1((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("extension2")) {
      Object obj = map.get("extension2");
      if(obj != null) {
        if(obj instanceof String){
            this.setExtension2((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("extension3")) {
      Object obj = map.get("extension3");
      if(obj != null) {
        if(obj instanceof String){
            this.setExtension3((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sales_list_config")) {
      Object obj = map.get("sales_list_config");
      if(obj != null) {
        if(obj instanceof String){
            this.setSalesListConfig((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("scan_client_scan_model")) {
      Object obj = map.get("scan_client_scan_model");
      if(obj != null) {
        if(obj instanceof String){
            this.setScanClientScanModel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sharepoint_send_image_num")) {
      Object obj = map.get("sharepoint_send_image_num");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSharepointSendImageNum((Long)obj);
        } else if(obj instanceof String) {
            this.setSharepointSendImageNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSharepointSendImageNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("websocket_url")) {
      Object obj = map.get("websocket_url");
      if(obj != null) {
        if(obj instanceof String){
            this.setWebsocketUrl((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("discern_entity_codes")) {
      Object obj = map.get("discern_entity_codes");
      if(obj != null) {
        if(obj instanceof String){
            this.setDiscernEntityCodes((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("file_to_annex_seconds")) {
      Object obj = map.get("file_to_annex_seconds");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setFileToAnnexSeconds((Long)obj);
        } else if(obj instanceof String) {
            this.setFileToAnnexSeconds(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setFileToAnnexSeconds(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("verify_to_annex_seconds")) {
      Object obj = map.get("verify_to_annex_seconds");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setVerifyToAnnexSeconds((Long)obj);
        } else if(obj instanceof String) {
            this.setVerifyToAnnexSeconds(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setVerifyToAnnexSeconds(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("is_multipurpose_ticket")) {
      Object obj = map.get("is_multipurpose_ticket");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsMultipurposeTicket((String)obj);
        }
      } else{
      }
   }

  }

}
