package com.xforceplus.ultraman.app.imagesaas.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * ticket_source_file
 * </p>
 *
 * @author ultraman
 * @since 2022-03-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TicketSourceFile implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 文件名
   */
  private String fileName;
  /**
   * 文件类型
   */
  private String fileType;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 验真状态
   */
  private String checkStatus;
  /**
   * 是否匹配发票
   */
  private String isMatchInvoice;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人
   */
  private Long createUserId;
  /**
   * 修改人
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 文件地址
   */
  private String fileUrl;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("file_name", fileName);
      map.put("file_type", fileType);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_type", invoiceType);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("amount_with_tax", amountWithTax);
      map.put("check_status", checkStatus);
      map.put("is_match_invoice", isMatchInvoice);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("file_url", fileUrl);

      return map;
  }

  public static TicketSourceFile fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TicketSourceFile entity = new TicketSourceFile();

    if(map.containsKey("file_name")) {
      Object obj = map.get("file_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_type")) {
      Object obj = map.get("file_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("check_status")) {
      Object obj = map.get("check_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_match_invoice")) {
      Object obj = map.get("is_match_invoice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsMatchInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_url")) {
      Object obj = map.get("file_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileUrl((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("file_name")) {
      Object obj = map.get("file_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setFileName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("file_type")) {
      Object obj = map.get("file_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setFileType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("check_status")) {
      Object obj = map.get("check_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setCheckStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("is_match_invoice")) {
      Object obj = map.get("is_match_invoice");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsMatchInvoice((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("file_url")) {
      Object obj = map.get("file_url");
      if(obj != null) {
        if(obj instanceof String){
            this.setFileUrl((String)obj);
        }
      } else{
      }
   }

  }

}
