package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务日志类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-14
 */
public enum BusinessLogType {

    _1("1", "单证"),
    _2("2", "单据");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessLogType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessLogType fromCode(String code) {
        return Stream.of(BusinessLogType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
