package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 验签状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-14
 */
public enum CheckSignStatus {

    _0("0", "待验签"),
    _1("1", "验签成功"),
    _2("2", "验签失败"),
    _3("3", "无需验签");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CheckSignStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckSignStatus fromCode(String code) {
        return Stream.of(CheckSignStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
