package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 检测结果类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-14
 */
public enum CheckType {

    EXCEPTION("exception", "异常"),
    WARNING("warning", "预警");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CheckType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckType fromCode(String code) {
        return Stream.of(CheckType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
