package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 报关单类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-14
 */
public enum CustomsFormType {

    _1("1", "海关进口货物报关单"),
    _2("2", "海关出口货物报关单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CustomsFormType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CustomsFormType fromCode(String code) {
        return Stream.of(CustomsFormType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
