package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 异常状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-14
 */
public enum ExceptionStatus {

    _0("0", "无异常"),
    _1("1", "异常"),
    _2("2", "预警");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExceptionStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExceptionStatus fromCode(String code) {
        return Stream.of(ExceptionStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
