package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 影像文件类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-14
 */
public enum ImageFileType {

    _0("0", "影像"),
    _1("1", "文件");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ImageFileType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImageFileType fromCode(String code) {
        return Stream.of(ImageFileType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
