package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 影像状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-14
 */
public enum ImageStatus {

    _0("0", "删除"),
    _1("1", "正常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ImageStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImageStatus fromCode(String code) {
        return Stream.of(ImageStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
