package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-14
 */
public enum InvoiceType {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    SE("se", "增值税电子专用发票"),
    CE("ce", "增值税电子普通发票"),
    CJ("cj", "增值税普通发票（卷票)"),
    CT("ct", "增值税电子普通发票（通行费)"),
    CB("cb", "增值税电子普通发票（区块链）"),
    CD("cd", "通用电子发票"),
    J("j", "机动车销售统一发票"),
    VS("vs", "二手车销售统一发票"),
    IM("im", "通用机打发票"),
    P("p", "飞机票行程单"),
    T("t", "火车票"),
    TAXI("taxi", "出租车"),
    QUOTA("quota", "定额发票"),
    TOLL("toll", "过路费"),
    BUS("bus", "客运票"),
    FJ("fj", "附件"),
    MULTI("multi", "多票"),
    OTHER("other", "其他发票"),
    VIRTUAL("virtual", "影像文档"),
    QC("qc", "电子发票（普通发票）"),
    QS("qs", "电子发票（增值税专用发票）"),
    PAYMENT("payment", "海关缴款书"),
    CDF("cdf", "海关货物报关单"),
    SALE("sale", "销货清单"),
    FCE("fce", "通用财政票据（电子）"),
    FC("fc", "财政票据"),
    MOE("moe", "医疗门诊收费票据（电子）"),
    MHE("mhe", "医疗住院收费票据（电子）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code) {
        return Stream.of(InvoiceType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
