package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 批次号规则定义枚举值
 * </p>
 *
 * @author ultraman
 * @since 2023-07-14
 */
public enum RuleDefineEnums {

    _1400633397896187906("1400633397896187906", "机器编码");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RuleDefineEnums(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RuleDefineEnums fromCode(String code) {
        return Stream.of(RuleDefineEnums.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
