package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 任务类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-14
 */
public enum TaskType {

    _1("1", "影像识别"),
    _2("2", "发票验真"),
    _3("3", "文件转换"),
    _4("4", "pdf转换");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaskType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskType fromCode(String code) {
        return Stream.of(TaskType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
