package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单证检测ICON
 * </p>
 *
 * @author ultraman
 * @since 2023-07-14
 */
public enum TicketCheckIcons {

    BASE_CHECK("base_check", "基"),
    TITLE_CHECK("title_check", "购"),
    BLACKLIST_CHECK("blacklist_check", "黑"),
    SENSITIVE_CHECK("sensitive_check", "敏"),
    COORDINATION_CHECK("coordination_check", "销"),
    ELECTRONIC_CHECK("electronic_check", "匹"),
    ERROR_CODE_NO_CHECK("error_code_no_check", "串"),
    INVOICE_STATUS_CHECK("invoice_status_check", "状"),
    IS_REPLACE_CHECK("is_replace_check", "代"),
    LEGAL_PERSON_CHECK("legal_person_check", "主"),
    PERSON_CHECK("person_check", "购"),
    REPEAT_CHECK("repeat_check", "重"),
    SALES_LIST_CHECK("sales_list_check", "货"),
    CONSECUTIVE_CHECK("consecutive_check", "连"),
    SHEET_CHECK("sheet_check", "缺"),
    STAMPER_CHECK("stamper_check", "缺"),
    USER_AUTH_CHECK("user_auth_check", "权"),
    VERIFY_RESULT_CHECK("verify_result_check", "验"),
    SIGN_RESULT_CHECK("sign_result_check", "签"),
    PURCHASE_REPEAT_CHECK("purchase_repeat_check", "重"),
    SHEET_DEDUCT_CHECK("sheet_deduct_check", "抵"),
    TICKET_REMARK_CHECK("ticket_remark_check", "备"),
    REC_FAILED_CHECK("rec_failed_check", "识"),
    USED_AMOUNT_CHECK("used_amount_check", "提"),
    CUSTOMS_PAYMENT_CHECK("customs_payment_check", "海"),
    INVOICE_PURCHASER_TAX_NO_CHECK("invoice_purchaser_tax_no_check", "税"),
    ALL_ELECTRIC_AUTH_CHECK("all_electric_auth_check", "全"),
    IS_COVER_TICKET_CHECK("is_cover_ticket_check", "覆"),
    BALANCE_AMOUNT_CHECK("balance_amount_check", "余"),
    PURCHASE_COOPERATE_CHECK("purchase_cooperate_check", "回"),
    SPECIAL_INVOICE_CHECK("special_invoice_check", "特");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TicketCheckIcons(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TicketCheckIcons fromCode(String code) {
        return Stream.of(TicketCheckIcons.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
