package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单证状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-14
 */
public enum TicketStatus {

    _0("0", "未提交"),
    _1("1", "已提交"),
    _2("2", "已退票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TicketStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TicketStatus fromCode(String code) {
        return Stream.of(TicketStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
