package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据检测ICON
 * </p>
 *
 * @author ultraman
 * @since 2023-08-07
 */
public enum BillCheckIcons {

    COMPARE_COUNT_CHECK("compare_count_check", "张");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillCheckIcons(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillCheckIcons fromCode(String code) {
        return Stream.of(BillCheckIcons.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
