package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 文件操作类型
 * </p>
 *
 * @author ultraman
 * @since 2023-08-07
 */
public enum FileOperationType {

    COVER("cover", "覆盖"),
    HOOK("hook", "挂接");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FileOperationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileOperationType fromCode(String code) {
        return Stream.of(FileOperationType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
