package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单证类型
 * </p>
 *
 * @author ultraman
 * @since 2023-08-07
 */
public enum TicketType {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    D("d", "多票"),
    F("f", "附件");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TicketType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TicketType fromCode(String code) {
        return Stream.of(TicketType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
