package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 核验状态
 * </p>
 *
 * @author ultraman
 * @since 2023-08-07
 */
public enum VerifyStatus {

    _0("0", "待核验"),
    _2("2", "暂挂起"),
    _1("1", "核验合格"),
    _99("99", "核验不合格");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VerifyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VerifyStatus fromCode(String code) {
        return Stream.of(VerifyStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
