package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否
 * </p>
 *
 * @author ultraman
 * @since 2023-08-07
 */
public enum YesNo {

    _0("0", "否"),
    _1("1", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    YesNo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YesNo fromCode(String code) {
        return Stream.of(YesNo.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
