package com.xforceplus.ultraman.app.imagesaas.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * compare_ticket_plane
 * </p>
 *
 * @author ultraman
 * @since 2023-08-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CompareTicketPlane extends CompareTicket {

  /**
   * 乘客名称
   */
  private String nameOfPassenger;
  /**
   * 身份证号码
   */
  private String idNo;
  /**
   * 电子客单编号
   */
  private String eTicketNo;
  /**
   * 签注
   */
  private String endorsements;
  /**
   * 印刷序号
   */
  private String serialNo;
  /**
   * 提示信息
   */
  private String information;
  /**
   * 销售单位代号
   */
  private String agentCode;
  /**
   * 填开单位
   */
  private String issuedBy;
  /**
   * 填开日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dateOfIssue;
  /**
   * 保险费
   */
  private String insurance;
  /**
   * 票价
   */
  private BigDecimal fare;
  /**
   * 民航发展基金
   */
  private BigDecimal caacDevelopmentFund;
  /**
   * 燃油附加费
   */
  private BigDecimal fuelSurcharge;
  /**
   * 总金额
   */
  private BigDecimal total;
  /**
   * 其他税费
   */
  private BigDecimal tax;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("name_of_passenger", nameOfPassenger);
      map.put("id_no", idNo);
      map.put("e_ticket_no", eTicketNo);
      map.put("endorsements", endorsements);
      map.put("serial_no", serialNo);
      map.put("information", information);
      map.put("agent_code", agentCode);
      map.put("issued_by", issuedBy);
      map.put("date_of_issue", BocpGenUtils.toTimestamp(dateOfIssue));
      map.put("insurance", insurance);
      map.put("fare", fare);
      map.put("caac_development_fund", caacDevelopmentFund);
      map.put("fuel_surcharge", fuelSurcharge);
      map.put("total", total);
      map.put("tax", tax);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static CompareTicketPlane fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    CompareTicketPlane entity = new CompareTicketPlane();

    entity.setParentByOQSMap(map);
    if(map.containsKey("name_of_passenger")) {
      Object obj = map.get("name_of_passenger");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNameOfPassenger((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id_no")) {
      Object obj = map.get("id_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIdNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("e_ticket_no")) {
      Object obj = map.get("e_ticket_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setETicketNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endorsements")) {
      Object obj = map.get("endorsements");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEndorsements((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serial_no")) {
      Object obj = map.get("serial_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("information")) {
      Object obj = map.get("information");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInformation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agent_code")) {
      Object obj = map.get("agent_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issued_by")) {
      Object obj = map.get("issued_by");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssuedBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("date_of_issue")) {
      Object obj = map.get("date_of_issue");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDateOfIssue(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDateOfIssue((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDateOfIssue(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDateOfIssue(null);
      }
    }
    if(map.containsKey("insurance")) {
      Object obj = map.get("insurance");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInsurance((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fare")) {
      Object obj = map.get("fare");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFare((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFare(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFare(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFare(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFare(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("caac_development_fund")) {
      Object obj = map.get("caac_development_fund");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCaacDevelopmentFund((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCaacDevelopmentFund(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCaacDevelopmentFund(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCaacDevelopmentFund(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCaacDevelopmentFund(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("fuel_surcharge")) {
      Object obj = map.get("fuel_surcharge");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFuelSurcharge((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFuelSurcharge(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFuelSurcharge(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFuelSurcharge(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFuelSurcharge(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total")) {
      Object obj = map.get("total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax")) {
      Object obj = map.get("tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("name_of_passenger")) {
      Object obj = map.get("name_of_passenger");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNameOfPassenger((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id_no")) {
      Object obj = map.get("id_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIdNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("e_ticket_no")) {
      Object obj = map.get("e_ticket_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setETicketNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endorsements")) {
      Object obj = map.get("endorsements");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEndorsements((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serial_no")) {
      Object obj = map.get("serial_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("information")) {
      Object obj = map.get("information");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInformation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agent_code")) {
      Object obj = map.get("agent_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAgentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issued_by")) {
      Object obj = map.get("issued_by");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIssuedBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("date_of_issue")) {
      Object obj = map.get("date_of_issue");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDateOfIssue(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDateOfIssue((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDateOfIssue(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDateOfIssue(null);
      }
    }
    if(map.containsKey("insurance")) {
      Object obj = map.get("insurance");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInsurance((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fare")) {
      Object obj = map.get("fare");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setFare((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setFare(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setFare(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFare(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setFare(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("caac_development_fund")) {
      Object obj = map.get("caac_development_fund");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setCaacDevelopmentFund((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setCaacDevelopmentFund(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setCaacDevelopmentFund(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCaacDevelopmentFund(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setCaacDevelopmentFund(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("fuel_surcharge")) {
      Object obj = map.get("fuel_surcharge");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setFuelSurcharge((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setFuelSurcharge(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setFuelSurcharge(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFuelSurcharge(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setFuelSurcharge(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total")) {
      Object obj = map.get("total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax")) {
      Object obj = map.get("tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
