package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 子类型
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum BillCodeSubType {

    _0("0", "-"),
    _1("1", "差旅报销单"),
    _2("2", "其他费报单据");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillCodeSubType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillCodeSubType fromCode(String code) {
        return Stream.of(BillCodeSubType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
