package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据外部状态
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum ExtStatus {

    _0("0", "已提交"),
    _1("1", "驳回"),
    _2("2", "审核完成"),
    _3("3", "已作废"),
    _4("4", "审核后退回"),
    _5("5", "未挂接"),
    _99("99", "删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ExtStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExtStatus fromCode(String code) {
        return Stream.of(ExtStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
