package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 文件类型
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum FileType {

    PNG("PNG", "PNG"),
    JPG("JPG", "JPG"),
    JPEG("JPEG", "JPEG"),
    PDF("PDF", "PDF"),
    OFD("OFD", "OFD");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FileType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileType fromCode(String code) {
        return Stream.of(FileType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
