package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 影像扩展6
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum ImageExt6 {

    _1("1", "1");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ImageExt6(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImageExt6 fromCode(String code) {
        return Stream.of(ImageExt6.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
