package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 影像来源
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum ImageSource {

    _1("1", "扫描"),
    _2("2", "上传"),
    _3("3", "接口"),
    _99("99", "其他"),
    _4("4", "票税助手"),
    _5("5", "移动端上传"),
    _6("6", "滴滴卡包"),
    _7("7", "支付宝卡包"),
    _8("8", "微信卡包"),
    _9("9", "微信"),
    ANT("Ant", "协同"),
    _10("10", "复制链接"),
    _11("11", "进项业务单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ImageSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImageSource fromCode(String code) {
        return Stream.of(ImageSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
