package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否确认
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum IsConfirm {

    _0("0", "未确认"),
    _1("1", "已确认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsConfirm(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsConfirm fromCode(String code) {
        return Stream.of(IsConfirm.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
