package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 机器编码
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum MachineCode {

    _01("01", "01"),
    _02("02", "02");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MachineCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MachineCode fromCode(String code) {
        return Stream.of(MachineCode.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
