package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 运维类型
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum OperationType {

    PUSH_BILL("pushBill", "推送单据"),
    PUSH_TICKET("pushTicket", "推送单证"),
    RE_CHECK_BILL("reCheckBill", "重算单据"),
    RE_CHECK_TICKET("reCheckTicket", "重算单证"),
    RE_VERIFY("reVerify", "重新验真"),
    PDF_VERIFY_PASS("pdfVerifyPass", "PDF验签通过"),
    DELETE_TICKET("deleteTicket", "删除单证"),
    DELETE_BILL("deleteBill", "删除单据");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OperationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperationType fromCode(String code) {
        return Stream.of(OperationType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
