package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 收单状态
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum ReceiveStatus {

    _1("1", "待收票"),
    _2("2", "收票中"),
    _3("3", "已收齐待提交"),
    _4("4", "已提交稽核"),
    _5("5", "已退回");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReceiveStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReceiveStatus fromCode(String code) {
        return Stream.of(ReceiveStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
