package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 报销状态
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum ReimbursementStatus {

    _0("0", "未报销"),
    _2("2", "已报销");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReimbursementStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReimbursementStatus fromCode(String code) {
        return Stream.of(ReimbursementStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
