package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 任务历史种类
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum TaskHistoryType {

    _1("1", "异常"),
    _2("2", "补偿失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaskHistoryType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskHistoryType fromCode(String code) {
        return Stream.of(TaskHistoryType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
