package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 启用停用
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum UseStatus {

    _0("0", "停用"),
    _1("1", "启用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    UseStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static UseStatus fromCode(String code) {
        return Stream.of(UseStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
