package com.xforceplus.ultraman.app.imagesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 机动车发票联次
 * </p>
 *
 * @author ultraman
 * @since 2023-08-30
 */
public enum VehicleSheet {

    _1("1", "发票联"),
    _2("2", "抵扣联"),
    _3("3", "报税联"),
    _4("4", "注册登记联"),
    _5("5", "记账联"),
    _6("6", "存根联");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VehicleSheet(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VehicleSheet fromCode(String code) {
        return Stream.of(VehicleSheet.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
